/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block.material;

import mod.beethoven92.betterendforge.common.block.BulbVineLanternBlock;
import mod.beethoven92.betterendforge.common.block.material.ColoredMaterial;
import mod.beethoven92.betterendforge.common.block.template.ChandelierBlock;
import mod.beethoven92.betterendforge.common.block.template.EndAnvilBlock;
import mod.beethoven92.betterendforge.common.block.template.MetalPaneBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModCreativeTabs;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.item.EndAnvilItem;
import mod.beethoven92.betterendforge.common.item.HammerItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraftforge.fml.RegistryObject;

public class MetalMaterial {
    public final RegistryObject<Block> ore;
    public final RegistryObject<Block> block;
    public final RegistryObject<Block> tile;
    public final RegistryObject<Block> bars;
    public final RegistryObject<Block> pressure_plate;
    public final RegistryObject<Block> door;
    public final RegistryObject<Block> trapdoor;
    public final RegistryObject<Block> anvil;
    public final RegistryObject<Block> chain;
    public final RegistryObject<Block> stairs;
    public final RegistryObject<Block> slab;
    public final RegistryObject<Block> chandelier;
    public final RegistryObject<Block> bulb_lantern;
    public final ColoredMaterial bulb_lantern_colored;
    public final RegistryObject<Item> nugget;
    public final RegistryObject<Item> ingot;
    public final RegistryObject<Item> shovelHead;
    public final RegistryObject<Item> pickaxeHead;
    public final RegistryObject<Item> axeHead;
    public final RegistryObject<Item> hoeHead;
    public final RegistryObject<Item> swordBlade;
    public final RegistryObject<Item> swordHandle;
    public final RegistryObject<Item> shovel;
    public final RegistryObject<Item> sword;
    public final RegistryObject<Item> pickaxe;
    public final RegistryObject<Item> axe;
    public final RegistryObject<Item> hoe;
    public final RegistryObject<Item> hammer;
    public final RegistryObject<Item> helmet;
    public final RegistryObject<Item> chestplate;
    public final RegistryObject<Item> leggings;
    public final RegistryObject<Item> boots;
    public final boolean hasOre;
    public final String name;

    public static MetalMaterial makeNormal(String name, MaterialColor color, IItemTier material, IArmorMaterial armor) {
        return new MetalMaterial(name, true, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)color).func_235861_h_().func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB), material, armor);
    }

    public static MetalMaterial makeNormal(String name, MaterialColor color, float hardness, float resistance, IItemTier material, IArmorMaterial armor) {
        return new MetalMaterial(name, true, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)color).func_235861_h_().func_200948_a(hardness, resistance).func_200947_a(SoundType.field_185852_e), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB), material, armor);
    }

    public static MetalMaterial makeOreless(String name, MaterialColor color, IItemTier material, IArmorMaterial armor) {
        return new MetalMaterial(name, false, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)color).func_235861_h_().func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB), material, armor);
    }

    public static MetalMaterial makeOreless(String name, MaterialColor color, float hardness, float resistance, IItemTier material, IArmorMaterial armor) {
        return new MetalMaterial(name, false, AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)color).func_235861_h_().func_200948_a(hardness, resistance).func_200947_a(SoundType.field_185852_e), new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB), material, armor);
    }

    public MetalMaterial(String name, boolean hasOre, AbstractBlock.Properties blockSettings, Item.Properties itemSettings, IItemTier material, IArmorMaterial armor) {
        this.hasOre = hasOre;
        this.name = name;
        int anvilLevel = material.func_200925_d();
        AbstractBlock.Properties blockSettingsNotSolid = blockSettings.func_226896_b_();
        this.ore = hasOre ? ModBlocks.registerBlockWithDefaultItem(name + "_ore", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150377_bs))) : null;
        this.block = ModBlocks.registerBlockWithDefaultItem(name + "_block", () -> new Block(blockSettings));
        this.tile = ModBlocks.registerBlockWithDefaultItem(name + "_tile", () -> new Block(blockSettings));
        this.stairs = ModBlocks.registerBlockWithDefaultItem(name + "_stairs", () -> new StairsBlock(() -> ((Block)this.tile.get()).func_176223_P(), blockSettings));
        this.slab = ModBlocks.registerBlockWithDefaultItem(name + "_slab", () -> new SlabBlock(blockSettings));
        this.door = ModBlocks.registerBlockWithDefaultItem(name + "_door", () -> new DoorBlock(blockSettingsNotSolid));
        this.trapdoor = ModBlocks.registerBlockWithDefaultItem(name + "_trapdoor", () -> new TrapDoorBlock(blockSettingsNotSolid));
        this.anvil = ModBlocks.registerBlock(name + "_anvil", () -> new EndAnvilBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151574_g, (MaterialColor)((Block)this.block.get()).func_235697_s_()).func_235861_h_().func_200948_a(5.0f, 1200.0f).func_200947_a(SoundType.field_185858_k), anvilLevel));
        this.bars = ModBlocks.registerBlockWithDefaultItem(name + "_bars", () -> new MetalPaneBlock(blockSettings.func_200948_a(5.0f, 6.0f).func_226896_b_()));
        this.chain = ModBlocks.registerBlockWithDefaultItem(name + "_chain", () -> new ChainBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)((Block)this.block.get()).func_235697_s_()).func_235861_h_().func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_235597_S_).func_226896_b_()));
        this.pressure_plate = ModBlocks.registerBlockWithDefaultItem(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, blockSettings));
        ModItems.registerItem(name + "_anvil", () -> new EndAnvilItem((Block)this.anvil.get(), itemSettings));
        this.chandelier = ModBlocks.registerBlockWithDefaultItem(name + "_chandelier", () -> new ChandelierBlock(blockSettingsNotSolid.func_200942_a().func_235861_h_().func_235838_a_(state -> 15)));
        this.bulb_lantern = ModBlocks.registerBlockWithDefaultItem(name + "_bulb_lantern", () -> new BulbVineLanternBlock(blockSettings));
        this.bulb_lantern_colored = new ColoredMaterial(name + "_bulb_lantern", () -> new BulbVineLanternBlock(), this.bulb_lantern, false);
        this.nugget = ModItems.registerItem(name + "_nugget", () -> new Item(itemSettings));
        this.ingot = ModItems.registerItem(name + "_ingot", () -> new Item(itemSettings));
        this.shovelHead = ModItems.registerItem(name + "_shovel_head", () -> new Item(itemSettings));
        this.pickaxeHead = ModItems.registerItem(name + "_pickaxe_head", () -> new Item(itemSettings));
        this.axeHead = ModItems.registerItem(name + "_axe_head", () -> new Item(itemSettings));
        this.hoeHead = ModItems.registerItem(name + "_hoe_head", () -> new Item(itemSettings));
        this.swordHandle = ModItems.registerItem(name + "_sword_handle", () -> new Item(itemSettings));
        this.swordBlade = ModItems.registerItem(name + "_sword_blade", () -> new Item(itemSettings));
        this.shovel = ModItems.registerItem(name + "_shovel", () -> new ShovelItem(material, 1.5f, -3.0f, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.sword = ModItems.registerItem(name + "_sword", () -> new SwordItem(material, 3, -2.4f, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.pickaxe = ModItems.registerItem(name + "_pickaxe", () -> new PickaxeItem(material, 1, -2.8f, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.axe = ModItems.registerItem(name + "_axe", () -> new AxeItem(material, 6.0f, -3.0f, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.hoe = ModItems.registerItem(name + "_hoe", () -> new HoeItem(material, -3, 0.0f, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.hammer = ModItems.registerItem(name + "_hammer", () -> new HammerItem(material, 5.0f, -3.2f, 0.3, new Item.Properties().func_200916_a((ItemGroup)ModCreativeTabs.CREATIVE_TAB)));
        this.helmet = ModItems.registerItem(name + "_helmet", () -> new ArmorItem(armor, EquipmentSlotType.HEAD, itemSettings));
        this.chestplate = ModItems.registerItem(name + "_chestplate", () -> new ArmorItem(armor, EquipmentSlotType.CHEST, itemSettings));
        this.leggings = ModItems.registerItem(name + "_leggings", () -> new ArmorItem(armor, EquipmentSlotType.LEGS, itemSettings));
        this.boots = ModItems.registerItem(name + "_boots", () -> new ArmorItem(armor, EquipmentSlotType.FEET, itemSettings));
    }
}

